<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Agenda;
use App\Models\Profil;
use App\Models\RefSK;
use App\Models\Galeri;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\File;
use RealRashid\SweetAlert\Facades\Alert;
use Illuminate\Support\Str;

class GaleriController extends Controller
{
    public function index(){
        $level = Auth::user()->level;
        $profil = Profil::where('pt_id', 1)->first();
        $datas = Galeri::all();
        $refsks = RefSK::all();
        return view('admin.galeri.index',[
            'datas' => $datas,
            'level' => $level,
            'profil' => $profil,
            'refsks' => $refsks,
        ])->with('tittle', 'Galeri Desa');
    }

    public function add(){
        $level = Auth::user()->level;
        $profil = Profil::where('pt_id', 1)->first();
        $refsks = RefSK::all();
        return view('admin.galeri.add',[
            'level' => $level,
            'profil' => $profil,
            'refsks' => $refsks,
        ])->with('tittle', 'Galeri Desa');
    }

    public function store(Request $request){
        $request->validate([
            'jenis'     => 'required|string|max:50',
            'judul'     => 'required|string|max:255',
            // 'foto'      => 'required|mimes:jpeg,jpg,png',
        ]);

        $input = $request->all();
        $count=1;
        $image = $request->file('foto');
        foreach($image as $f => $name){
            $nama_file = date('dmYHis').'_'.$f.'.'.$name->getClientOriginalExtension();
            $tujuan_upload = public_path('../public/assets/images/galeri');
            $name->move($tujuan_upload,$nama_file);
            $data[]=$nama_file;
            $count++;
        }
        $input['foto'] = json_encode($data);
        $input['slug_judul'] = Str::slug($request->judul, '-');

        $simpan = Galeri::create($input);

        if ($simpan) {
            Alert::success('Berhasil', 'Data Telah Disimpan');
        }else {
            Alert::error('Gagal', 'Data Tidak Disimpan');
        }
        return redirect()->route('admin-galeri-index');
    }

    public function edit($id){
        $level = Auth::user()->level;
        $profil = Profil::where('pt_id', 1)->first();
        $data = Galeri::whereId($id)->first();
        $refsks = RefSK::all();
        return view('admin.galeri.edit',[
            'level' => $level,
            'profil' => $profil,
            'data' => $data,
            'refsks' => $refsks,
        ])->with('tittle', 'Galeri Desa');
    }

    public function update(Request $request){
		$request->validate([
            'jenis'     => 'required|string|max:50',
            'judul'     => 'required|string|max:255',
            // 'foto'      => 'required|mimes:jpeg,jpg,png|max:4096',
        ]);

		if(empty($request->foto)) {
			$simpan = Galeri::where('id', $request->id)->update([
				'jenis'	    => $request->jenis,
				'judul' 	=> $request->judul,
				'slug_judul'=> Str::slug($request->judul, '-'),
				'deskripsi'	=> $request->deskripsi,
				'updated_at'=> date('Y-m-d H-i-s')
			]);
		} else {
			//baca foto lama
			$fotolama = Galeri::where('id', $request->id)->first();
			$count=1;
			$image = $request->file('foto');
			$decode = json_decode($fotolama->foto);
			// fungsi hapus gambar di direktori
			foreach ($decode as $foto) {
				$path = public_path('assets/images/galeri');
				$file_lama = $foto;
				$lokasi = $path.'/'.$file_lama;
				if(File::exists($lokasi)) {
					File::delete($lokasi);
				}
				$count++;
			}
			//fungsi simpan galeri
			foreach ($image as $f => $name) {
				//simpan ke direktori
				$nama_file = date('dmYHis').'_'.$f.'.'.$name->getClientOriginalExtension();
				$tujuan_upload = public_path('../public/assets/images/galeri');
				$name->move($tujuan_upload,$nama_file);
				$data[]=$nama_file;
				$count++;
			}

			$simpan = Galeri::where('id', $request->id)->update([
				'jenis'	    => $request->jenis,
				'judul' 	=> $request->judul,
				'foto' 	    => json_encode($data),
				'slug_judul'=> Str::slug($request->judul, '-'),
				'deskripsi'	=> $request->deskripsi,
				'updated_at'=> date('Y-m-d H-i-s')
			]);
		}

		if ($simpan) {
            Alert::success('Berhasil', 'Data Telah Disimpan');
        }else {
            Alert::error('Gagal', 'Data Tidak Disimpan');
        }
        return redirect()->route('admin-galeri-index');
	}

    public function delete($id)
    {
        $path = public_path('../public/assets/images/galeri');
        $hapus_gambar = Galeri::where('id', $id)->first(); 

        if ($hapus_gambar) { 
            $fotos = json_decode($hapus_gambar->foto); 

            if (is_array($fotos)) {
                foreach ($fotos as $i) {
                    $nama_file = $i->foto ?? null; 
                    if ($nama_file) {
                        $lokasi = $path . '/' . $nama_file;
                        if (File::exists($lokasi)) {
                            File::delete($lokasi);
                        }
                    }
                }
            }

            $hapus_gambar->delete();

            Alert::success('Berhasil', 'Data Telah Dihapus');
        } else {
            Alert::error('Gagal', 'Data Tidak Ditemukan');
        }

        return redirect()->route('admin-galeri-index');
    }


}
