<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Menu;
use App\Models\Profil;
use App\Models\RefSK;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Validator;
use RealRashid\SweetAlert\Facades\Alert;
use Illuminate\Support\Str;

class MenuController extends Controller
{
    public function index(){
        $level = Auth::user()->level;
        $datas = Menu::all();
        $menus = Menu::where('kode_induk', NULL)->where('alamat_link', NULL)->get();
        $profil = Profil::where('pt_id', 1)->first();
        $refsks = RefSK::all();
        return view('admin.menu.index',[
            'datas' => $datas,
            'menus' => $menus,
            'level' => $level,
            'profil' => $profil,
            'refsks' => $refsks,
        ])->with('tittle', 'Pengelolaan Navbar');
    }

    public function store(Request $request){
        $request->validate([
            'nama'      => 'required',
        ]);

        $input = $request->all();
        $input['nama'] = strtoupper($request->nama);
        if($request->kode_induk=='pilih'){
            $kode_induk = NULL;
        }else{
            $kode_induk = $request->kode_induk;
        }
        $input['kode_induk'] = $kode_induk;
        $input['slug_nama'] = Str::slug($request->nama, '-');
        $input['status'] = 'aktif';

        $simpan = Menu::create($input);

        if ($simpan) {
            Alert::success('Berhasil', 'Data Telah Disimpan');
        }else {
            Alert::error('Gagal', 'Data Tidak Disimpan');
        }
        return redirect()->route('admin-menu-index');
    }

    public function update(Request $request, $id){
        $request->validate([
            'nama'      => 'required',
        ]);

        if($request->kode_induk=='pilih'){
            $kode_induk = NULL;
        }else{
            $kode_induk = $request->kode_induk;
        }

        if(empty($request->alamat_link)){
            $alamat_link = NULL;
        }else{
            $alamat_link = $request->alamat_link;
        }

        $simpan = Menu::where('id', $id)->update([
            'nama' => strtoupper($request->nama),
            'slug_nama' => Str::slug($request->nama, '-'),
            'kode_induk' => $kode_induk,
            'alamat_link' => $alamat_link,
            'urutan' => $request->urutan,
        ]);

        if ($simpan) {
            Alert::success('Berhasil', 'Data Telah Diubah');
        }else {
            Alert::error('Gagal', 'Data Tidak Diubah');
        }
        return redirect()->route('admin-menu-index');
    }

    public function delete($id) {
        $hapusdata = Menu::where('id', $id)->delete();

        if ($hapusdata) {
            Alert::success('Berhasil', 'Data Telah Dihapus');
        } else {
            Alert::error('Gagal', 'Data Tidak Dihapus');
        }

        return redirect()->route('admin-menu-index');
    }

    public function status(Request $request, $id){
        $simpan = Menu::where('id', $id)->update([
            'status' => $request->status,
        ]);
        return redirect()->route('admin-menu-index');
    }
}
