<?php

namespace App\Http\Controllers\Admin\SK;

use App\Http\Controllers\Controller;
use App\Models\Penduduk;
use App\Models\Perangkat;
use App\Models\Profil;
use App\Models\RefSK;
use App\Models\SkDomisili;
use Barryvdh\DomPDF\Facade\Pdf;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use RealRashid\SweetAlert\Facades\Alert;
use Yajra\DataTables\Facades\DataTables;

class DomisiliController extends Controller
{
    public function index(){
        $level = Auth::user()->level;
        $profil = Profil::where('pt_id', 1)->first();
        $refsks = RefSK::all();
        $penduduks = Penduduk::where('status','aktif')->get();
        return view('admin.SK.domisili.index',[
            'level' => $level,
            'profil' => $profil,
            'refsks' => $refsks,
            'penduduks' => $penduduks,
        ])->with('tittle', 'Surat Keterangan Domisili' );
    }

    public function getData(Request $request)
    {
        if ($request->ajax()) {
            // Query untuk mengambil data dengan join tabel penduduks
            $domisilis = SkDomisili::query()
                        ->leftjoin('penduduks', 'penduduks.id', '=', 'sk_domisilis.nik')
                        ->select(
                            'sk_domisilis.id as domisili_id',
                            'sk_domisilis.no_surat',
                            'sk_domisilis.tgl_surat',
                            'sk_domisilis.pekerjaan',
                            'sk_domisilis.perihal',
                            'sk_domisilis.nik as nik_pemohon',
                            'penduduks.nama_lengkap as nama_pemohon',
                        )          
                        ->orderBy('sk_domisilis.id', 'desc');
            
            // Menghasilkan DataTables response
            return DataTables::of($domisilis)
                ->addIndexColumn()

                // Menambahkan kolom opsi edit dan delete
                ->addColumn('opsi', function ($row) {
                    return '
                        <a href="'.route(Auth::user()->level . '-sk-domisili-cetak', $row->domisili_id).'" target="_blank" class="btn btn-icon btn-sm btn-outline btn-outline-primary text-hover-white mb-1 cetak">
                            <i class="bi bi-printer text-primary fs-4" data-bs-toggle="tooltip" title="Cetak"></i>
                        </a>
                        <a href="javascript:void(0)" data-id="'.$row->domisili_id.'" class="btn btn-icon btn-sm btn-outline btn-outline-info text-hover-white mb-1 edit-domisili">
                            <i class="bi bi-pencil text-info fs-4" data-bs-toggle="tooltip" data-bs-custom-class="tooltip-dark" data-bs-placement="top" title="Update"></i>
                        </a>
                        <a href="javascript:void(0)" data-id="'.$row->domisili_id.'" class="btn btn-icon btn-sm btn-outline btn-outline-danger text-hover-white mb-1 delete-domisili">
                            <i class="bi bi-trash text-danger fs-4" data-bs-toggle="tooltip" title="Hapus"></i>
                        </a>
                    ';
                })

                // Mengubah format tanggal menjadi format Indonesia (dd-mm-yyyy)
                ->addColumn('tgl_surat_indo', function($row) {
                    return date('d-m-Y', strtotime($row->tgl_surat));
                })

                // Menambahkan kolom NIK dan Nama Lengkap
                ->addColumn('nik_nama', function($row) {
                    return $row->nik_pemohon . '<br><strong>' . $row->nama_pemohon . '</strong>';
                    // return '<br><strong>' . $row->nik . '</strong>';
                })

                // Menentukan kolom yang boleh mengandung HTML
                ->rawColumns(['opsi', 'nik_nama'])

                ->make(true);
        }
    }

    public function store(Request $request)
    {
        $request->validate([
            'nik'       => 'required|exists:penduduks,id',
            'no_surat'  => 'required|string',
            'tgl_surat' => 'required',
            'pekerjaan' => 'required',
            'perihal'   => 'required',
        ]);

        $input = $request->all();
        $simpan = SkDomisili::create($input);
        if ($simpan) {
            Alert::success('Berhasil', 'Data SK Domisili berhasil ditambahkan.');
        }else {
            Alert::error('Gagal', 'Data SK Domisili gagal ditambahkan.');
        }

        return redirect()->route('admin-sk-domisili-index');
    }

    public function getDataId($id)
    {
        $domisili = SkDomisili::findOrFail($id);
        return response()->json($domisili);
    }

    public function update(Request $request, $id)
    {
        $request->validate([
            'nik'       => 'required|exists:penduduks,id',
            'no_surat'  => 'required|string',
            'tgl_surat' => 'required',
            'pekerjaan' => 'required',
            'perihal'   => 'required',
        ]);
        $domisili = SkDomisili::findOrFail($id);
        $simpan = $domisili->update([
            'nik'            => $request->nik,
            'no_surat'       => $request->no_surat,
            'tgl_surat'      => $request->tgl_surat,
            'pekerjaan'      => $request->pekerjaan,
            'perihal'        => $request->perihal,
        ]);
        if ($simpan) {
            Alert::success('Berhasil', 'Data SK Domisili berhasil diperbarui.');
        }else {
            Alert::error('Gagal', 'Data SK Domisili gagal diperbarui.');
        }

        return redirect()->route('admin-sk-domisili-index');
    }

    public function delete($id)
    {
        $domisili = SkDomisili::findOrFail($id);
        $simpan = $domisili->delete();

        if ($simpan) {
            Alert::success('Berhasil', 'Data SK Domisili berhasil dihapus!');
        }else {
            Alert::error('Gagal', 'Data SK Domisili gagal dihapus!');
        }

        return redirect()->route('admin-sk-domisili-index');
    }

    public function cetak1($id)
    {
        // Ambil data berdasarkan ID
        $domisili = SkDomisili::with('penduduk')->findOrFail($id);

        // Render halaman HTML untuk diubah menjadi PDF
        $pdf = Pdf::loadView('pdf.domisili', compact('domisili'));
        // $pdf = Pdf::loadView('admin.SK.domisili.template', compact('profil','data','penduduk','kades'));

        // Return PDF untuk ditampilkan di browser
        return $pdf->stream('surat_domisili.pdf'); // Jika ingin download, ganti dengan ->download('nama-file.pdf')
    }

    public function cetak($id){
        $profil = Profil::where('pt_id', 1)->first();
        $data = SkDomisili::where('id', $id)->first();
        $penduduk = Penduduk::where('id', $data->nik)->first();
        $kades = Perangkat::where('jabatan','Kepala Desa')->first();
        return view('admin.SK.domisili.template',[
            'profil' => $profil, 
            'data' => $data, 
            'penduduk' => $penduduk,
            'kades' => $kades,
        ]);
    }
}
