@extends('guest.layouts.master')
@section('css')
@endsection
@section('content')
<div class="hero page-inner overlay"style="background-image: url({{ asset('guest/images/hero_bg_3.jpg') }})">
    <div class="container">
      <div class="row justify-content-center align-items-center">
        <div class="col-lg-9 text-center mt-5">
          <h1 class="heading" data-aos="fade-up">{{ $tittle }}</h1>
          <nav aria-label="breadcrumb"data-aos="fade-up"data-aos-delay="200">
            <ol class="breadcrumb text-center justify-content-center">
              <li class="breadcrumb-item"><a href="{{ route('beranda') }}">Beranda</a></li>
              <li class="breadcrumb-item active text-white-50"aria-current="page">{{ $tittle }}</li>
            </ol>
          </nav>
        </div>
      </div>
    </div>
</div>
<div class="section">
  <div class="container">
    <div class="row mb-5">
      @if (count($per_pkk)==0)
        <div class="alert alert-danger">
          <h4>Belum ada Anggota PKK yang ditambahkan!</h4>
        </div>
      @else
        @foreach ($per_pkk as $data)
        <div class="col-md-3 mb-3">    
            <div class="card" style=" height:28rem">
                <img src="{{ asset('assets/images/perangkat/'.$data?->foto) }}" class="card-img-top" alt="{{ $data?->nama }}" height="80%">
                <div class="card-body text-center">
                    <h5 class="card-title">{{ $data?->nama }}</h5>
                    <span class="fs-6 mt-3">{{ $data?->jabatan }}</span>
                </div>
            </div>
        </div>
        @endforeach
      @endif
    </div>
  </div>
</div>
@endsection
@section('js')
@endsection