<!-- /*
* Template Name: Property
* Template Author: Untree.co
* Template URI: https://untree.co/
* License: https://creativecommons.org/licenses/by/3.0/
*/ -->
<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
  <head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <meta name="author" content="<?php echo e($profil?->nama); ?>" />
    <link rel="shortcut icon" href="<?php echo e(asset('assets/media/logos/favicon.ico')); ?>" />

    <meta name="description" content="<?php echo e($profil?->tentang); ?>" />
    <meta name="keywords" content="pt, cv, properti, property, pangandaran, parigi, batukaras, ciamis, banjar, pantai" />

    <title><?php echo e($tittle); ?> - <?php echo e($profil?->nama); ?></title>
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link href="https://fonts.googleapis.com/css2?family=Work+Sans:wght@400;500;600;700&display=swap" rel="stylesheet"/>

    <link rel="stylesheet" href="<?php echo e(asset('/guest/fonts/icomoon/style.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('/guest/fonts/flaticon/font/flaticon.css')); ?>" />

    <link rel="stylesheet" href="<?php echo e(asset('/guest/css/tiny-slider.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('/guest/css/aos.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('/guest/css/style.css')); ?>" />
    <?php echo $__env->yieldContent('css'); ?>
  </head>
  <body>
    <div class="site-mobile-menu site-navbar-target">
      <div class="site-mobile-menu-header">
        <div class="site-mobile-menu-close">
          <span class="icofont-close js-menu-toggle"></span>
        </div>
      </div>
      <div class="site-mobile-menu-body"></div>
    </div>
    <?php echo $__env->make('guest.item.navbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->yieldContent('content'); ?>
    <?php echo $__env->make('guest.item.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- /.site-footer -->

    <!-- Preloader -->
    <div id="overlayer"></div>
    <div class="loader">
      <div class="spinner-border" role="status">
        <span class="visually-hidden">Loading...</span>
      </div>
    </div>

    <script src="<?php echo e(asset('/guest/js/bootstrap.bundle.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/guest/js/tiny-slider.js')); ?>"></script>
    <script src="<?php echo e(asset('/guest/js/aos.js')); ?>"></script>
    <script src="<?php echo e(asset('/guest/js/navbar.js')); ?>"></script>
    <script src="<?php echo e(asset('/guest/js/counter.j')); ?>s"></script>
    <script src="<?php echo e(asset('/guest/js/custom.js/')); ?>"></script>
    <?php echo $__env->yieldContent('js'); ?>
  </body>
</html>
<?php /**PATH C:\xampp\htdocs\cv\resources\views/guest/layouts/master.blade.php ENDPATH**/ ?>