@extends('admin.layouts.master')
@section('css')
<link href="{{ asset('assets/fileinput/css/fileinput.css') }}" media="all" rel="stylesheet" type="text/css"/>
<link href="{{ asset('assets/fileinput/themes/explorer-fas/theme.css') }}" media="all" rel="stylesheet" type="text/css"/>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/baguettebox.js/1.10.0/baguetteBox.min.css"/>
@endsection
@section('content')
<!--begin::Toolbar-->
<div class="toolbar mt-2" id="kt_toolbar">
    <!--begin::Container-->
    <div id="kt_toolbar_container" class="container-fluid d-flex flex-stack">
        <!--begin::Page title-->
        <div data-kt-swapper="true" data-kt-swapper-mode="prepend" data-kt-swapper-parent="{default: '#kt_content_container', 'lg': '#kt_toolbar_container'}" class="page-title d-flex align-items-center flex-wrap me-3 mb-5 mb-lg-0">
            <!--begin::Title-->
            <h1 class="d-flex align-items-center text-dark fw-bolder fs-3 my-1">{{ $tittle }}</h1>
            <!--end::Title-->
            <!--begin::Separator-->
            <span class="h-20px border-gray-300 border-start mx-4"></span>
            <!--end::Separator-->
            <!--begin::Breadcrumb-->
            <ul class="breadcrumb breadcrumb-separatorless fw-bold fs-7 my-1">
                <!--begin::Item-->
                <li class="breadcrumb-item text-muted">
                    <a href="{{ route('admin-dashboard') }}" class="text-muted text-hover-primary">Beranda</a>
                </li>
                <li class="breadcrumb-item">
                    <span class="bullet bg-gray-300 w-5px h-2px"></span>
                </li>
                <li class="breadcrumb-item text-muted">{{ $tittle }}</li>
                <!--end::Item-->
            </ul>
            <!--end::Breadcrumb-->
        </div>
        <!--end::Page title-->
    </div>
</div>
<!--begin::Post-->
<div class="post d-flex flex-column-fluid mt-0">
    <!--begin::Container-->
    <div class="container">
        <!--begin::Pricing card-->
        <a href="{{ route('admin-galeri-index') }}" class="btn btn-sm btn-info mb-2"><i class="bi bi-arrow-left me-1"></i> Kembali</a>
        <div class="card">
            <div class="card-header">
                <h3 class="card-title align-items-start flex-column">
                    <span class="card-label fw-bolder text-dark">Form Edit {{ $tittle }}</span>
                </h3>
            </div>
            <!--begin::Card body-->
            <div class="card-body p-lg-5">
                <form action="{{route('admin-galeri-update')}}" method="post" enctype="multipart/form-data">
                    @csrf
                    <div class="row">
                        <div class="col-md-4">
                            <div class="d-flex flex-column mb-7 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                    <span class="required">Pilih Jenis</span>
                                </label>
                                @php
                                    $jeniss=['Foto','Video'];
                                @endphp
                                <select name="jenis" id="jenis" class="form-control form-select{{ $errors->has('jenis') ? ' is-invalid' : '' }}">
                                    @foreach ($jeniss as $jenis)
                                    <option value="{{ $jenis }}"{{ $data->jenis == $jenis ? 'selected' : NULL }}>{{ $jenis }}</option>
                                    @endforeach
                                </select>
                                @if($errors->has('jenis'))
                                    <span class="invalid-feedback">{{ $errors->first('jenis') }}</span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-8">
                            <div class="d-flex flex-column mb-7 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                    <span class="required">Judul</span>
                                </label>
                                <input type="hidden" name="id" id="id" class="form-control{{ $errors->has('id') ? ' is-invalid' : '' }}" value="{{ $data->id }}">
                                <input type="text" name="judul" id="judul" class="form-control{{ $errors->has('judul') ? ' is-invalid' : '' }}" value="{{ $data->judul }}">
                                @if($errors->has('judul'))
                                    <span class="invalid-feedback">{{ $errors->first('judul') }}</span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="d-flex flex-column mb-7 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                    <span class="">Foto Terupload</span>
                                </label>
                                <section class="compact-gallery" style="background:#fff; padding:15px;">
                                    <?php
                                        $decode = json_decode($data->foto);
                                    ?>
                                    @foreach ($decode as $foto)
                                        <a class="lightbox" href="{{asset('assets/images/galeri/'.$foto.'')}}">
                                            <img class="img-fluid image" src="{{asset('assets/images/galeri/'.$foto.'')}}" width="100" height="100" style="object-fit:cover; margin:5px;">
                                        </a>
                                    @endforeach
                                </section>
                            </div>
                        </div>
                        <div class="col-md-8">
                            <div class="form-group mb-7">
                                <label class=" form-label">Unggah Foto</label>
                                <div class="file-loading">
                                    <label>Preview File Icon</label>
                                    <input id="file-3" type="file" name="foto[]" class="form-control{{ $errors->has('foto') ? ' is-invalid' : '' }}" multiple>
                                    @if($errors->has('foto'))
                                        <span class="invalid-feedback">{{ $errors->first('foto') }}</span>
                                    @endif
                                </div>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group mb-7">
                                <label class="form-label">Deskripsi</label>
                                <textarea name="deskripsi" id="kt-tinymce-4" class="tox-target" rows="5">{{ $data->deskripsi }}</textarea>
                            </div>
                        </div>
                    </div><hr>
                    <div class="text-center">
                        <button type="submit"class="btn btn-primary"><i class="fas fa-save fs-4 me-1"></i> Simpan</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
@section('js')

<!-- Fileinput -->
<script src="{{ asset('assets/fileinput/js/plugins/piexif.js') }}" type="text/javascript"></script>
<script src="{{ asset('assets/fileinput/js/plugins/sortable.js') }}" type="text/javascript"></script>
<script src="{{ asset('assets/fileinput/js/fileinput.js') }}" type="text/javascript"></script>
<script src="{{ asset('assets/fileinput/js/locales/fr.js') }}" type="text/javascript"></script>
<script src="{{ asset('assets/fileinput/js/locales/es.js') }}" type="text/javascript"></script>
<script src="{{ asset('assets/fileinput/themes/fas/theme.js') }}" type="text/javascript"></script>
<script src="{{ asset('assets/fileinput/themes/explorer-fas/theme.js') }}" type="text/javascript"></script>

<script src="{{ asset('assets/plugins/custom/tinymce/tinymce.bundle.js') }}"></script>
<script src="{{ asset('assets/plugins/custom/tinymce/tinymce.js') }}"></script>
<script>
    $("#file-3").fileinput({
        rtl: true,
        theme: 'fas',
        showUpload: false,
        showCaption: true,
        dropZoneEnabled: false,
        browseClass: "btn btn-primary btn-md",
        allowedFileExtensions: ["jpg", "jpeg", "png"],
        previewFileIcon: "<i class='glyphicon glyphicon-king'></i>",
        overwriteInitial: true,
        initialPreviewAsData: true,
        maxFileSize: 2048,
        mainClass: "input-group",
        
    });    
</script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/baguettebox.js/1.10.0/baguetteBox.min.js"></script>
<script>
    baguetteBox.run('.compact-gallery', { animation: 'slideIn'});
</script>
@endsection