
<?php $__env->startSection('css'); ?>
<link href="https://cdn.datatables.net/1.13.1/css/dataTables.bootstrap5.min.css" rel="stylesheet" type="text/css" />
<link href="<?php echo e(asset('assets/fileinput/css/fileinput.css')); ?>" media="all" rel="stylesheet" type="text/css"/>
<link href="<?php echo e(asset('assets/fileinput/themes/explorer-fas/theme.css')); ?>" media="all" rel="stylesheet" type="text/css"/>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<!--begin::Toolbar-->
<div class="toolbar mt-2" id="kt_toolbar">
    <!--begin::Container-->
    <div id="kt_toolbar_container" class="container-fluid d-flex flex-stack">
        <!--begin::Page title-->
        <div data-kt-swapper="true" data-kt-swapper-mode="prepend" data-kt-swapper-parent="{default: '#kt_content_container', 'lg': '#kt_toolbar_container'}" class="page-title d-flex align-items-center flex-wrap me-3 mb-5 mb-lg-0">
            <!--begin::Title-->
            <h1 class="d-flex align-items-center text-dark fw-bolder fs-3 my-1"><?php echo e($tittle); ?></h1>
            <!--end::Title-->
            <!--begin::Separator-->
            <span class="h-20px border-gray-300 border-start mx-4"></span>
            <!--end::Separator-->
            <!--begin::Breadcrumb-->
            <ul class="breadcrumb breadcrumb-separatorless fw-bold fs-7 my-1">
                <!--begin::Item-->
                <li class="breadcrumb-item text-muted">
                    <a href="<?php echo e(route('admin-dashboard')); ?>" class="text-muted text-hover-primary">Beranda</a>
                </li>
                <li class="breadcrumb-item">
                    <span class="bullet bg-gray-300 w-5px h-2px"></span>
                </li>
                <li class="breadcrumb-item text-muted"><?php echo e($tittle); ?></li>
                <!--end::Item-->
            </ul>
            <!--end::Breadcrumb-->
        </div>
        <!--end::Page title-->
    </div>
</div>
<!--begin::Post-->
<div class="post d-flex flex-column-fluid mt-0">
    <!--begin::Container-->
    <div class="container">
        <!--begin::Pricing card-->
        <div class="card">
            <div class="card-header bg-secondary">
                <h3 class="card-title align-items-start flex-column">
                    <span class="card-label fw-bolder text-dark">List <?php echo e($tittle); ?></span>
                </h3>
                <div class="card-toolbar">
                    
                    <a href="<?php echo e(route('admin-galeri-add')); ?>" class="btn btn-sm btn-primary"><i class="bi bi-plus-lg me-1"></i> Tambah</a>
                </div>
            </div>
            <!--begin::Card body-->
            <div class="card-body p-lg-5">
                <table id="datatable" class="table table-striped table-row-bordered gy-4 gs-7 border rounded">
                    <thead>
                        <tr class="fw-bolder bg-secondary fs-6 text-gray-800 px-7">
                            <th width="7%" class="align-middle">No</th>
                            <th class="align-middle text-center" width="10%">Opsi</th>
                            <th class="align-middle text-center">Foto</th>
                            <th class="align-middle">Judul</th>
                            <th class="align-middle">Deskripsi</th>
                            <th class="align-middle">Keterangan</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $datas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $decode = json_decode($data->foto);
                            if (empty($data->foto)) {
                                $foto = "noimage.png";
                            } else {
                                $foto = $data->foto;
                            }
                            $jumlahkarakter=150;
                            $cetak = substr($data->deskripsi, 0, $jumlahkarakter);
                            $hasil = strip_tags($cetak);
                        ?>
                            <tr>
                                <td class="align-middle"><?php echo e($loop->iteration); ?></td>
                                <td class="align-middle">
                                    <a href="<?php echo e(route('admin-galeri-edit', ['id'=>$data->id])); ?>" class="btn btn-icon btn-sm btn-outline btn-outline-info text-hover-white">
                                        <i class="bi bi-pencil text-info fs-4" data-bs-toggle="tooltip" data-bs-custom-class="tooltip-dark" data-bs-placement="top" title="Update"></i>
                                    </a>
                                    <a href="javascrip:void(0)" data-bs-toggle="modal" data-bs-target="#delete-<?php echo e($data->id); ?>" class="btn btn-icon btn-sm btn-outline btn-outline-danger text-hover-white">
                                        <i class="bi bi-trash text-danger fs-4" data-bs-toggle="tooltip" data-bs-custom-class="tooltip-dark" data-bs-placement="top" title="Hapus"></i>
                                    </a>
                                </td>
                                <td class="align-middle">
                                    <section class="compact-gallery">
                                        <?php $__currentLoopData = $decode; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $foto): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <a class="lightbox" href="<?php echo e(asset('assets/images/galeri/'.$foto.'')); ?>">
                                                <img class="img-fluid image" src="<?php echo e(asset('assets/images/galeri/'.$foto.'')); ?>" width="50" height="50" style="object-fit:cover;">
                                            </a>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </section>
                                </td>
                                <td class="align-middle"><?php echo e($data->judul); ?></td>
                                <td class="align-middle"><?php echo e($hasil); ?></td>
                                <td class="align-middle">
                                    <b>Tgl Input: </b><?php echo e(date('d M Y h:s', strtotime($data->created_at))); ?><br>
                                    <b>Tgl Update: </b><?php echo e(date('d M Y h:s', strtotime($data->updated_at))); ?>

                                </td>
                            </tr>
                            
                            <?php echo $__env->make('admin.galeri.item.modal-delete', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<script src="https://code.jquery.com/jquery-3.5.1.js"></script>
<script src="https://cdn.datatables.net/1.13.1/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.1/js/dataTables.bootstrap5.min.js"></script>

<!-- Fileinput -->
<script src="<?php echo e(asset('assets/fileinput/js/plugins/piexif.js')); ?>" type="text/javascript"></script>
<script src="<?php echo e(asset('assets/fileinput/js/plugins/sortable.js')); ?>" type="text/javascript"></script>
<script src="<?php echo e(asset('assets/fileinput/js/fileinput.js')); ?>" type="text/javascript"></script>
<script src="<?php echo e(asset('assets/fileinput/js/locales/fr.js')); ?>" type="text/javascript"></script>
<script src="<?php echo e(asset('assets/fileinput/js/locales/es.js')); ?>" type="text/javascript"></script>
<script src="<?php echo e(asset('assets/fileinput/themes/fas/theme.js')); ?>" type="text/javascript"></script>
<script src="<?php echo e(asset('assets/fileinput/themes/explorer-fas/theme.js')); ?>" type="text/javascript"></script>

<script>
    $(document).ready(function () {
        $('#datatable').DataTable({
            // "lengthMenu": [ [25, 50, 100, -1], [25, 50, 100, "All"] ],
            // "iDisplayLength": 25
        });
    });

    $("#file-3").fileinput({
        theme: 'fas',
        showUpload: false,
        showCaption: true,
        dropZoneEnabled: false,
        browseClass: "btn btn-primary btn-md",
        previewFileIcon: "<i class='glyphicon glyphicon-king'></i>",
        overwriteInitial: true,
        initialPreviewAsData: true,
    });    
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/pand6342/public_html/panyutran.desa.ids/resources/views/admin/galeri/index.blade.php ENDPATH**/ ?>