<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Patner;
use App\Models\Profil;
use App\Models\RefSK;
use Dotenv\Store\File\Paths;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\File;
use RealRashid\SweetAlert\Facades\Alert;
use Illuminate\Support\Str;

class PatnerController extends Controller
{
    public function index(){
        $level = Auth::user()->level;
        $datas = Patner::all();
        $profil = Profil::where('pt_id', 1)->first();
        $refsks = RefSK::all();
        return view('admin.patner.index',[
            'datas' => $datas,
            'level' => $level,
            'profil' => $profil,
            'refsks' => $refsks,
        ])->with('tittle', 'Pengelolaan Patner');
    }

    public function store(Request $request){
        $request->validate([
            // 'nama'      => 'required',
        ]);

        $input = $request->all();
        $input['nama'] = strtoupper($request->nama);
        if (empty($request->logo)) {
            $nama_file = NULL;
        } else {
            $image = $request->file('logo');
            $nama_file = date('dmYHis').'.'.$image->getClientOriginalExtension();
            $tujuan_upload = public_path('../public/assets/images/patner');
            $image->move($tujuan_upload,$nama_file);
        }
        $input['slug_nama'] = Str::slug($request->nama, '-');
        $input['logo'] = $nama_file;

        $simpan = Patner::create($input);

        if ($simpan) {
            Alert::success('Berhasil', 'Data Telah Disimpan');
        }else {
            Alert::error('Gagal', 'Data Tidak Disimpan');
        }
        return redirect()->route('admin-patner-index');
    }

    public function update(Request $request, $id){
        $request->validate([
            'nama'      => 'required',
        ]);

        $data = Patner::where('id', $id)->first();

        if (empty($request->logo)) {
            $nama_file = $data->logo;
        } else {
            $image = $request->file('logo');
            $nama_file = date('dmYHis').'.'.$image->getClientOriginalExtension();
            $tujuan_upload = public_path('../public/assets/images/patner');
            $image->move($tujuan_upload,$nama_file);

            $lokasi = $tujuan_upload.'/'.$data->logo;
            if(File::exists($lokasi)) {
                File::delete($lokasi);
            }
        }

        $simpan = Patner::where('id', $request->id)->update([
            'nama' => $request->nama,
            'slug_nama' => Str::slug($request->nama, '-'),
            'logo' => $nama_file,
            'jenis_usaha' => $request->jenis_usaha,
        ]);

        if ($simpan) {
            Alert::success('Berhasil', 'Data Telah Disimpan');
        }else {
            Alert::error('Gagal', 'Data Tidak Disimpan');
        }
        return redirect()->route('admin-patner-index');
    }

    public function delete($id) {
        $data = Patner::where('id', $id)->first();
        $direktori = public_path('../public/assets/images/patner');
        $lokasi = $direktori.'/'.$data->foto;
        if(File::exists($lokasi)) {
            File::delete($lokasi);
        }
        $hapusdata = Patner::where('id', $id)->delete();

        if ($hapusdata) {
            Alert::success('Berhasil', 'Data Telah Dihapus');
        } else {
            Alert::error('Gagal', 'Data Tidak Dihapus');
        }

        return redirect()->route('admin-patner-index');
    }
}
