@extends('admin.layouts.master')
@section('css')

@endsection
@section('content')
<!--begin::Toolbar-->
<div class="toolbar mt-2" id="kt_toolbar">
    <!--begin::Container-->
    <div id="kt_toolbar_container" class="container-fluid d-flex flex-stack">
        <!--begin::Page title-->
        <div data-kt-swapper="true" data-kt-swapper-mode="prepend" data-kt-swapper-parent="{default: '#kt_content_container', 'lg': '#kt_toolbar_container'}" class="page-title d-flex align-items-center flex-wrap me-3 mb-5 mb-lg-0">
            <!--begin::Title-->
            <h1 class="d-flex align-items-center text-dark fw-bolder fs-3 my-1">{{ $tittle }}</h1>
            <!--end::Title-->
            <!--begin::Separator-->
            <span class="h-20px border-gray-300 border-start mx-4"></span>
            <!--end::Separator-->
            <!--begin::Breadcrumb-->
            <ul class="breadcrumb breadcrumb-separatorless fw-bold fs-7 my-1">
                <!--begin::Item-->
                <li class="breadcrumb-item text-muted">
                    <a href="{{ route('admin-dashboard') }}" class="text-muted text-hover-primary">Beranda</a>
                </li>
                <!--end::Item-->
                <!--begin::Item-->
                <li class="breadcrumb-item">
                    <span class="bullet bg-gray-300 w-5px h-2px"></span>
                </li>
                <!--end::Item-->
                <!--begin::Item-->
                <li class="breadcrumb-item text-muted">{{ $tittle }}</li>
                <!--end::Item-->
            </ul>
            <!--end::Breadcrumb-->
        </div>
        <!--end::Page title-->
    </div>
</div>
<!--begin::Post-->
<div class="post d-flex flex-column-fluid mt-0">
    <!--begin::Container-->
    <div class="container">
        <!--begin::Pricing card-->
        <div class="card">
            <div class="card-header bg-secondary">
                <h3 class="card-title align-items-start flex-column">
                    <span class="card-label fw-bolder text-dark">Form Tambah</span>
                </h3>
                <div class="card-toolbar">
                    
                </div>
            </div>
            <!--begin::Card body-->
            <div class="card-body p-lg-5">
                @if (count($errors) > 0)
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
                @endif
                <!--begin::Form-->
                <form type="POST" action="{{ route('admin-surat-store',['jenis'=>$jenis]) }}" method="post" enctype="multipart/form-data">
                    @csrf
                    <!--begin::Input group-->
                    <div class="row">
                        <div class="col-md-3">
                            <div class="d-flex flex-column mb-7 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                    <span class="required">Nomor Surat Tugas</span>
                                </label>
                                <select name="surat_id" id="surat_id" class="form-control form-select{{ $errors->has('surat_id') ? ' is-invalid' : '' }}">
                                    @foreach ($surats as $surat)
                                    <option value="{{ $surat->id }}">{{ $surat->nomor }} ({{ date('d-m-Y', strtotime($surat->tgl_surat)) }})</option>
                                    @endforeach
                                </select>
                                @if($errors->has('surat_id'))
                                    <span class="invalid-feedback">{{ $errors->first('surat_id') }}</span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="d-flex flex-column mb-7 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                    <span class="required">Tanggal Nota Dinas</span>
                                </label>
                                <input type="date" class="form-control" name="tgl_nota" id="tgl_nota" placeholder="Masukan disini!" value="{{ old('tgl_nota') }}"/>
                                @if($errors->has('tgl_nota'))
                                    <span class="invalid-feedback">{{ $errors->first('tgl_nota') }}</span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="d-flex flex-column mb-7 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                    <span class="required">Penyelenggara</span>
                                </label>
                                <input type="text" class="form-control" name="penyelenggara" id="penyelenggara" placeholder="Masukan disini!" value="{{ old('penyelenggara') }}"/>
                                @if($errors->has('penyelenggara'))
                                    <span class="invalid-feedback">{{ $errors->first('penyelenggara') }}</span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="d-flex flex-column mb-7 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                    <span class="required">Acara/Kegiatan</span>
                                </label>
                                <textarea type="text" class="form-control" name="acara" id="acara" placeholder="Masukan disini!" value="{{ old('acara') }}" rows="4"></textarea>
                                @if($errors->has('acara'))
                                    <span class="invalid-feedback">{{ $errors->first('acara') }}</span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="d-flex flex-column mb-7 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                    <span class="required">Peserta</span>
                                </label>
                                <textarea type="text" class="form-control" name="peserta" id="peserta" placeholder="Masukan disini!" value="{{ old('peserta') }}" rows="4"></textarea>
                                @if($errors->has('peserta'))
                                    <span class="invalid-feedback">{{ $errors->first('peserta') }}</span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="d-flex flex-column mb-7 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                    <span class="required">Laporan Hasil Kegiatan</span>
                                </label>
                                <textarea type="text" class="form-control" name="hasil" id="kt-tinymce-4" placeholder="Masukan disini!" value="{{ old('hasil') }}" rows="10"></textarea>
                                @if($errors->has('hasil'))
                                    <span class="invalid-feedback">{{ $errors->first('hasil') }}</span>
                                @endif
                            </div>
                        </div>
                    </div><hr>
                    <!--begin::Actions-->
                    <div class="text-center pt-2">
                        <button type="reset" class="btn btn-danger">
                            <span class="indicator-label">Batal</span>
                        </button>
                        <button type="submit" class="btn btn-primary">
                            <span class="indicator-label">Simpan</span>
                        </button>
                    </div>
                    <!--end::Actions-->
                </form>
                <!--end::Form-->
            </div>
        </div>
    </div>
</div>
@endsection
@section('js')
<script src="{{ asset('assets/plugins/custom/tinymce/tinymce.bundle.js') }}"></script>
<script src="{{ asset('assets/plugins/custom/tinymce/tinymce.js') }}"></script>
@endsection