@extends('guest.layouts.master')
@section('css')
@endsection
@section('content')
<div class="hero page-inner overlay"style="background-image: url({{ asset('guest/images/hero_bg_3.jpg') }})">
    <div class="container">
      <div class="row justify-content-center align-items-center">
        <div class="col-lg-9 text-center mt-5">
          <h1 class="heading" data-aos="fade-up">{{ $tittle }}</h1>
          <nav aria-label="breadcrumb"data-aos="fade-up"data-aos-delay="200">
            <ol class="breadcrumb text-center justify-content-center">
              <li class="breadcrumb-item"><a href="{{ route('beranda') }}">Beranda</a></li>
              <li class="breadcrumb-item active text-white-50"aria-current="page">{{ $tittle }}</li>
            </ol>
          </nav>
        </div>
      </div>
    </div>
</div>
<div class="section">
  <div class="container">
    <div class="row justify-content-between mb-5">
      <div class="col-md-8">
        @if (count($beritas)==0)
            <div class="alert alert-danger">
              <h4>Belum ada berita yang ditambahkan!</h4>
            </div>
          @else
            @foreach ($beritas as $data)
            @php
                $jumlahkarakter=250;
                $cetak = substr($data?->isi_berita, 0, $jumlahkarakter);
                $hasil = strip_tags($cetak);
            @endphp 
            <div class="card mb-3">
              <div class="row g-0">
                <div class="col-md-4">
                  <img src="{{ asset('assets/images/berita/'.$data?->foto) }}" class="img-fluid rounded-start" alt="{{ $data->slug }}">
                </div>
                <div class="col-md-8">
                  <div class="card-body">
                    <h5 class="card-title"><a href="{{ url('/berita/'.$data?->slug_judul.'') }}"><span style="font-size: 15px;">{{ $data?->judul }}</span></a></h5>
                    <p class="card-text">{{ $hasil }}...</p>
                    {{-- <p class="card-text"><small class="text-muted"><i class="fa fa-user"></i> Admin Desa</small> | <i class="fa fa->clock"></i> {{ date('d-m-Y H:i') }}</p> --}}
                    <span class="d-block d-flex align-items-center me-3">
                      <span class="icon-user me-2"> Admin || </span>
                      <span class="icon-clock-o me-2"> {{ date('d M Y h:s', strtotime($data?->tanggal)) }}</span>
                      <span>Dibaca: {{ $data->baca }} Kali</span>
                    </span>
                    {{-- <p class="text-end"><a href="{{ url('/berita/'.$data?->slug_judul.'') }}" class="btn btn-primary btn-sm">Selengkapnya</a></p> --}}
                  </div>
                </div>
              </div>
            </div>
            @endforeach
          @endif
        <nav>
          {{$beritas->links('guest.item.pagination')}}
        </nav>
      </div>
      <div class="col-md-4">
        @include('guest.item.side.populer')
        {{-- @include('guest.item.side.perangkat') --}}
      </div>
    </div>
  </div>
</div>
@endsection
@section('js')
@endsection